// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

#include "uniformWorldConstants.h"
#include "uniformShaderConstants.h"
#include "fragmentVersionSimple.h"
#include "uniformPerFrameConstants.h"

/////////////////////////////////////////////////////////////////
///////////////////////// STOP! /////////////////////////////////
/////////////////////////////////////////////////////////////////
// Made by Sad - @bamboo_sapling
// successfully changed on Dec 2020.
// all of these assets are under MIT license.
/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////

uniform highp float TOTAL_REAL_WORLD_TIME;
varying highp vec3 pos;

#include "lib/hash.glsl"
#include "lib/bsbe.glsl"
#include "lib/colorp.glsl"

vec4 clouds(highp vec2 pos){
    vec3 tot = vec3(1.5,1.5,1.5),sha = mix(fc.rgb,fc.rgb*2.5,rain);
    float val = 2.2-rain,a = .0;
    for(int i = 0; i < 10; i++){
        float den = fbm(pos, val);
        val /= cin; pos /= 1.035;
        if(den > 0.0){
            vec3 cc = mix(mix(mix(dccolor, nccolor, nfog),sccolor, dfog),fc.rgb*1.5, rain);
                cc = mix(cc*2.,sha*den,den);
            tot = mix(tot,cc,den);
            a += mix(0.,(1.-den*.5)*(1.-a),den);
        }
        sha /= 1.03;
    }
return vec4(tot,a);
}

void main(){

    vec4 tot = vec4(0.,0.,0.,0.);
    vec3 npos = normalize(vec3(pos.x, pos.y-.128,pos.z));
    vec3 po = npos/(npos.y-.14);
    vec4 cloud = clouds(vec2(-po.x,po.z)*.8);
    float ugrad = clamp(length(po.xz)*.03,0.,1.);
    vec4 usc = vec4(sky(ugrad),1);

    float place = clamp(npos.y,0.,.4)*2.5+.7,place1= clamp(-npos.y,0.,.4)*2.5+.6;
        tot.rgb = (npos.y>0.)?usc.rgb:cloud.rgb;
        tot.a = (npos.y>0.)?usc.a*min(pow(place,13.),1.):clamp((cloud.a-.6)*cv,0.,1.)*min(pow(place1,10.),1.);
        tot.rgb = final(tot.rgb);

gl_FragColor = tot;

}
